/* Wiktor Zychla, 2003 */
using System;
using System.Collections;

namespace Example
{
  public class COsoba : IComparable
  {
    public string imie;
    public string nazwisko;

    public int CompareTo( object o )
    {
      if ( o is COsoba )
      {
        COsoba o2 = o as COsoba;
        
        if ( this.nazwisko == o2.nazwisko )
          return this.imie.CompareTo( o2.imie );
        else
          return this.nazwisko.CompareTo( o2.nazwisko );
      }
      else
        return -1;
    }

    public override string ToString()
    {
      return String.Format( "{0} {1}", nazwisko, imie );
    } 

    public COsoba( string imie, string nazwisko )
    {
      this.imie = imie; this.nazwisko = nazwisko;
    } 
  }

  public class CExample 
  {
    static void Wypisz( IEnumerable ie )
    {
       foreach ( object o in ie )
         Console.WriteLine( "{0},", o );
    }

    public static void Main(string[] args)
    {
       ArrayList atab = new ArrayList();		

       atab.Add( new COsoba( "Jan", "Kowalski" ) );
       atab.Add( new COsoba( "Zdzisaw", "Kowalski" ) );
       atab.Add( new COsoba( "Jan", "Malinowski" ) );
       atab.Add( new COsoba( "Tomasz", "Abacki" ) );

       Wypisz( atab );
       atab.Sort();
       Wypisz( atab );
    }
  }
}
